<?php 
require("../fpdf/fpdf.php");
include("../config/dbcon.php");

if (isset($_GET['invoice_no'])) {
    $invoiceNo = $_GET['invoice_no'];

    // Fetch order and customer details
    $orderQuery = "SELECT o.*, c.* FROM tbl_order_penb o JOIN tbl_customers_penb c ON c.id = o.customer_id WHERE o.invoice_no = '$invoiceNo' LIMIT 1";
    $orderQueryRes = mysqli_query($conn, $orderQuery);

    if ($orderQueryRes && mysqli_num_rows($orderQueryRes) > 0) {
        $orderDataRow = mysqli_fetch_assoc($orderQueryRes);

        // Store customer details in variables for easy access
        $customerName = $orderDataRow['fld_customer_name'];
        $customerAddress1 = $orderDataRow['fld_customer_address1'];
        $customerAddress2 = $orderDataRow['fld_customer_address2'];
        $customerCity = $orderDataRow['fld_customer_city'];
        $customerPoscode = $orderDataRow['fld_customer_poscode'];
        $customerState = $orderDataRow['fld_customer_state'];
        $plateNumber = $orderDataRow['plate_number'];
        $deposit = $orderDataRow['deposit'];
        $orderDate = $orderDataRow['order_date']; // Ensure this field exists in your database
        $salePerson = $orderDataRow['order_place_by_id']; // Ensure this field exists in your database

        // Fetch items and assign to $products and $laborCharges arrays
        $orderItemQuery = 
            "SELECT 
                  oi.quantity AS orderItemQuantity, oi.price AS orderItemPrice, o.invoice_no, p.id AS product_id, 
                  p.fld_product_name AS product_name, lb.id AS labor_id, lb.charge_desc AS labor_name
              FROM  tbl_order_penb AS o 
              JOIN tbl_order_items AS oi ON oi.order_id = o.id
              LEFT JOIN tbl_products_penb AS p ON p.id = oi.product_id
              LEFT JOIN tbl_labourcharge_penb AS lb ON lb.id = oi.product_id 
              WHERE o.invoice_no = '$invoiceNo'";

        $orderItemRes = mysqli_query($conn, $orderItemQuery);

        if ($orderItemRes && mysqli_num_rows($orderItemRes) > 0) {
            $products = [];
            $laborCharges = [];
            $totalProductAmount = 0;
            $totalLaborChargeAmount = 0;

            while ($orderItemRow = mysqli_fetch_assoc($orderItemRes)) {
                if (!empty($orderItemRow['labor_id'])) {
                    // It's a labor charge
                    $laborCharges[] = $orderItemRow;
                    $totalLaborChargeAmount += $orderItemRow['orderItemPrice'] * $orderItemRow['orderItemQuantity'];
                } else {
                    // It's a product
                    $products[] = $orderItemRow;
                    $totalProductAmount += $orderItemRow['orderItemPrice'] * $orderItemRow['orderItemQuantity'];
                }
            }

           

        } else {
            echo '<h5>No record found</h5>';
        }
    } else {
        echo "Order not found.";
    }
} else {
    echo "Invalid request.";
}

class PDF extends FPDF {

    function Header() {
        // Add fonts
        $this->AddFont("Montserrat-Regular", "", "Montserrat-Regular.php");
        $this->AddFont("Montserrat-Medium", "", "Montserrat-Medium.php");
        $this->AddFont("Montserrat-Bold", "", "Montserrat-Bold.php");

        // Add logo
        $this->Image('../logo.jpeg', 15, 9, 20); 

        // Set font and display company details
        $this->SetFont("Montserrat-Regular", "", 9);
        $this->SetY(7);
        $this->SetX(40);
        $this->Cell(50, 7, "KSQ 10 ENTERPRISE", 0, 1);
        $this->SetY(13);
        $this->SetX(40);
        $this->Cell(50, 7, "9632 JARAK ATAS,", 0, 1);
        $this->SetY(19);
        $this->SetX(40);
        $this->Cell(50, 7, "TASEK GELUGOR PNG 13310", 0, 1);
        $this->SetY(25);
        $this->SetX(40);
        $this->Cell(50, 7, "Malaysia", 0, 1);

        $this->SetY(7);
        $this->SetX(-40);
        $this->SetFont("Montserrat-Medium", "", 12);
        $this->Cell(50, 10, "Workshop &", 0, 1);

        $this->SetY(13);
        $this->SetX(-28);
        $this->SetFont("Montserrat-Medium", "", 12);
        $this->Cell(50, 10, "Repair", 0, 1);

        $this->SetDrawColor(169, 169, 169); 
        $this->Line(10, 37, 202, 37);
        $this->SetY(50);
    }

    function Body($products, $laborCharges, $customerName, $customerAddress1, $customerAddress2, $customerCity, $customerPoscode, $customerState, $plateNumber, $orderDate, $salePerson, $deposit) {
        $grandTotal = 0;
        $this->SetFont("Montserrat-Regular", "", 11);
        
        // Initial Y-position for the customer details
        $yPos = $this->GetY();
        
        // Display customer details
        $this->SetY($yPos - 6);
        $this->SetX(10);
        $this->Cell(50, 7, "$customerName - $plateNumber");
        
        // Track if any address line is shown to adjust the invoice number position
        $addressDisplayed = false;
        
        // Display $customerAddress1 if it's not empty
        if (!empty($customerAddress1)) {
            $this->SetY($this->GetY() + 7);
            $this->SetX(10);
            $this->Cell(50, 7, "$customerAddress1");
            $addressDisplayed = true;
        }
        
        // Display $customerAddress2 if it's not empty
        if (!empty($customerAddress2)) {
            $this->SetY($this->GetY() + 7);
            $this->SetX(10);
            $this->Cell(50, 7, "$customerAddress2");
            $addressDisplayed = true;
        }
        
        // Display $customerCity and $customerPoscode if either is not empty
        if (!empty($customerCity) || !empty($customerPoscode)) {
            $this->SetY($this->GetY() + 7);
            $this->SetX(10);
            $this->Cell(50, 7, "$customerCity $customerPoscode");
            $addressDisplayed = true;
        }
        
        // Display $customerState if it's not empty
        if (!empty($customerState)) {
            $this->SetY($this->GetY() + 7);
            $this->SetX(10);
            $this->Cell(50, 7, $customerState);
            $addressDisplayed = true;
        }
        
        // Adjust Y-position for invoice based on whether the address was displayed
        if ($addressDisplayed) {
            $this->SetY($this->GetY() + 10); // Extra space if address was shown
        } else {
            $this->SetY($yPos); // Move closer if no address lines were shown
        }
        
        // Display invoice details
        $this->SetX(-80);
        $this->SetFont("Montserrat-Regular", "", 18);
        $this->Cell(50, 10, "Receipt " . $_GET['invoice_no'], 0, 1);

        // Display Quotation Date and Source in the same row
        $this->SetY($this->GetY() + 2);
        $this->SetX(10); // Position for Quotation Date
        $this->SetFont("Montserrat-Medium", "", 10);
        $this->Cell(30, 10, "Quotation Date:", 0, 0); // No line break to stay in the same row

        $this->SetFont("Montserrat-Regular", "", 10);
        $this->Cell(40, 10, "$orderDate", 0, 0); // No line break to stay in the same row

        $this->SetX(90); // Position for Source next to the Quotation Date
        $this->SetFont("Montserrat-Medium", "", 10);
        $this->Cell(30, 10, "Source:", 0, 0); // No line break

        $this->SetX(105);
        $this->SetFont("Montserrat-Regular", "", 10);
        $this->Cell(50, 10, "$salePerson", 0, 1); // Move to the next line after Source

       // Initialize subtotal variables
        $productSubtotal = 0;
        $laborSubtotal = 0;
       

       // Adjust the Y position to move the line up
        $this->SetY($this->GetY() + 2); // Adjust as needed for your layout
        $this->SetDrawColor(169, 169, 169);
        $this->Line(10, $this->GetY() - 2, 202, $this->GetY() - 2);

        // Display Table headings
        $this->SetY($this->GetY() + 2);
        $this->SetX(10);
        $this->SetFont("Montserrat-Medium", "", 10);
        $this->Cell(90, 9, "Description", 0, 0);
        $this->Cell(40, 9, "Unit Price", 0, 0);
        $this->Cell(20, 9, "Quantity", 0, 0);
        $this->Cell(20, 9, "Total", 0, 1, 'R');

      


        $this->SetFont("Montserrat-Regular", "", 10);

        // Display Item Title with background color
        $this->SetFillColor(200, 200, 200); // Set background color
        $this->SetY($this->GetY() + 1); 
        $this->SetX(10);
        $this->SetFont("Montserrat-Medium", "", 12);
        $this->Cell(190, 9, "Item", 0, 1, 'L', true);

        $productNumber = 1; // Initialize product numbering

        // Iterate through products
        $this->SetFont("Montserrat-Regular", "", 11); 
        foreach ($products as $product) {
            // Save starting Y position for the row
            $startY = $this->GetY();
            $this->SetX(10);

            // Add numbering for each product
            $this->Cell(10, 9, $productNumber++, 0, 0, 'C'); // Increment the numbering

            // Use MultiCell for product name to handle long names
            $this->MultiCell(100, 9, $product['product_name'], 0, 'L');

            // Calculate the height of the MultiCell content
            $nameHeight = $this->GetY() - $startY;

            // Reset Y position back to the top of the row for other cells
            $this->SetY($startY);
            $this->SetX(120); // Position after product name (90px width)

            // Unit Price
            $this->Cell(40, 9, number_format($product['orderItemPrice'], 2), 0, 0);

            // Quantity
            $this->Cell(20, 9, $product['orderItemQuantity'], 0, 0);

            // Total Price (right-aligned)
            $this->Cell(20, 9, number_format($product['orderItemPrice'] * $product['orderItemQuantity'], 2), 0, 1, 'R');
            $productSubtotal += $product['orderItemPrice'] * $product['orderItemQuantity'];

            // Move Y position down based on the tallest cell content
            $this->SetY($startY + max($nameHeight, 9)); // Ensure it moves down by at least 9 units for consistent spacing
        }

        // Display Product Subtotal
        $this->SetFont("Montserrat-Medium", "", 11);
        $this->SetY($this->GetY() + 1);
        $this->SetX($this->GetX() + 140);
        $this->Cell(50, 10, "Subtotal: RM " . number_format($productSubtotal, 2), 0, 1, 'R');

        // Display Labour Charge Title with background color
        $this->SetFillColor(200, 200, 200); // Set background color
        $this->SetY($this->GetY() + 2); 
        $this->SetX(10);
        $this->SetFont("Montserrat-Medium", "", 12);
        $this->Cell(190, 9, "Labour Charge", 0, 1, 'L', true);

        $chargeNumber = 1;

        // Iterate through labor charges
        $this->SetFont("Montserrat-Regular", "", 11); 
        foreach ($laborCharges as $laborCharge) {
            // Save starting Y position for the row
            $startsY = $this->GetY();
            $this->SetX(10);

            $this->Cell(10, 9, $chargeNumber++, 0, 0, 'C');
            // Use MultiCell for product name to handle long names
            $this->MultiCell(90, 9, $laborCharge['labor_name'], 0, 'L');

            // Calculate the height of the MultiCell content
            $nameHeights = $this->GetY() - $startsY;

            // Reset Y position back to the top of the row for other cells
            $this->SetY($startsY);
            $this->SetX(120); // Position after product name (90px width)

            // Unit Price
            $this->Cell(40, 9, number_format($laborCharge['orderItemPrice'], 2), 0, 0);

            // Quantity
            $this->Cell(20, 9, $laborCharge['orderItemQuantity'], 0, 0);

            // Total Price (right-aligned)
            $this->Cell(20, 9, number_format($laborCharge['orderItemPrice'] * $laborCharge['orderItemQuantity'], 2), 0, 1, 'R');
            $laborSubtotal += $laborCharge['orderItemPrice'] * $laborCharge['orderItemQuantity'];

            // Move Y position down based on the tallest cell content
            $this->SetY($startsY + max($nameHeights, 9)); // Ensure it moves down by at least 9 units for consistent spacing
}

            // Display Labour Charge Subtotal
            $this->SetFont("Montserrat-Medium", "", 11);
            $this->SetY($this->GetY() + 1);
            $this->SetX($this->GetX() + 140);
            $this->Cell(50, 10, "Subtotal: RM " . number_format($laborSubtotal, 2), 0, 1, 'R');


            $this->SetY($this->GetY() + 3); // Adjust as needed for your layout
            $this->SetDrawColor(169, 169, 169);
            $this->Line(10, $this->GetY() - 2, 202, $this->GetY() - 2);

            // Calculate grand total
            $total = $productSubtotal + $laborSubtotal;

            // Display Total
            $this->SetFont("Montserrat-Regular", "", 12);
            $this->SetY($this->GetY() + 1);
            $this->SetX($this->GetX() + 20);
            $this->Cell(140, 10, "Total :", 0, 0, 'R');
            $this->Cell(30, 10, "RM " . number_format($total, 2), 0, 1, 'R');

            // Display Deposit
            $this->SetFont("Montserrat-Regular", "", 12);
            $this->SetY($this->GetY() + 1); 
            $this->SetX($this->GetX() + 20);
            $this->Cell(140, 10, "Deposit :", 0, 0, 'R');
            $this->Cell(30, 10, "-RM " . number_format($deposit, 2), 0, 1, 'R');

            // Calculate Grand Total
            $grandTotal = $total - $deposit;

            // Display Grand Total
            $this->SetFont("Montserrat-Bold", "", 12);
            $this->SetY($this->GetY() + 1);
            $this->SetX($this->GetX() + 20);
            $this->Cell(140, 10, "Grand Total :", 0, 0, 'R');
            $this->Cell(30, 10, "RM " . number_format($grandTotal, 2), 0, 1, 'R');


            //Additional Info

            $this->SetFont("Montserrat-Regular", "", 12);
            $this->SetY($this->GetY() + 3);
            $this->SetX($this->GetX() + 4);
            $this->Cell(50, 10, "Thank you for your business! We look forward to serving you again.", 0, 1, 'L');


        


    }

    function Footer() {

              $this->SetY(-20); // Adjusted Y position to make space for lines
              $this->SetFont("Montserrat-Regular", "", 10);

              // Get page width
              $pageWidth = $this->GetPageWidth();
              
              // Define the text to be displayed in the footer
              $footerText = "0176996718 ksq10global@gmail.com";
              
              // Calculate the width of the text
              $textWidth = $this->GetStringWidth($footerText);

              // Set X position to center the text
              $this->SetX(($pageWidth - $textWidth) / 2);
              
              // Draw line above the text
              $this->Line(10, $this->GetY() - 2, $pageWidth - 10, $this->GetY() - 2);

              // Output the text
              $this->Cell($textWidth, 10, $footerText, 0, 1, "C");

              // Draw line below the text
              $this->Line(10, $this->GetY() + 2, $pageWidth - 10, $this->GetY() + 2);
              // Add some space below the lines
              $this->Ln(2);

              $this->Cell(0, 10, 'Page ' . $this->PageNo(), 0, 0, 'C');
    }
}

 // Create PDF instance
$pdf = new PDF();
$pdf->AddPage();

// Generate the PDF content
$pdf->Body($products, $laborCharges, $customerName, $customerAddress1, $customerAddress2, $customerCity, $customerPoscode, $customerState, $plateNumber, $orderDate, $salePerson, $deposit);

// Rename the file using invoice number
$pdfFilename = 'Receipt_' . $_GET['invoice_no'] . '.pdf';

// Output the PDF
$pdf->Output('I', $pdfFilename);
?>
