<?php 
require("../fpdf/fpdf.php");
include("../config/dbcon.php");

if (isset($_GET['invoice_no'])) {
    $invoiceNo = $_GET['invoice_no'];

    // Fetch order and customer details
    $orderQuery = "SELECT o.*, c.* FROM tbl_order_penb o JOIN tbl_customers_penb c ON c.id = o.customer_id WHERE o.invoice_no = '$invoiceNo' LIMIT 1";
    $orderQueryRes = mysqli_query($conn, $orderQuery);

    if ($orderQueryRes && mysqli_num_rows($orderQueryRes) > 0) {
        $orderDataRow = mysqli_fetch_assoc($orderQueryRes);

        // Store customer details in variables for easy access
        $customerName = $orderDataRow['fld_customer_name'];
        $customerAddress1 = $orderDataRow['fld_customer_address1'];
        $customerAddress2 = $orderDataRow['fld_customer_address2'];
        $customerCity = $orderDataRow['fld_customer_city'];
        $customerPoscode = $orderDataRow['fld_customer_poscode'];
        $customerState = $orderDataRow['fld_customer_state'];
        $plateNumber = $orderDataRow['plate_number'];

        // Fetch products and labor charges
        $orderItemQuery = "SELECT 
            oi.quantity AS orderItemQuantity, oi.price AS orderItemPrice, 
            p.fld_product_name AS product_name, lb.charge_desc AS labor_name
            FROM tbl_order_penb AS o 
            JOIN tbl_order_items AS oi ON oi.order_id = o.id
            LEFT JOIN tbl_products_penb AS p ON p.id = oi.product_id
            LEFT JOIN tbl_labourcharge_penb AS lb ON lb.id = oi.product_id 
            WHERE o.invoice_no = '$invoiceNo'";

        $orderItemRes = mysqli_query($conn, $orderItemQuery);

        $products_info = [
            'ITEM' => [],
            'LABOUR CHARGE, UPAH' => []
        ];

        // Store order details
        $orderDate = $orderDataRow['order_date'];
        $salePerson = $orderDataRow['order_place_by_id'];

        if ($orderItemRes) {
            while ($orderItemRow = mysqli_fetch_assoc($orderItemRes)) {
                if (!empty($orderItemRow['labor_name'])) {
                    // Add to labor charges
                    $products_info['LABOUR CHARGE, UPAH'][] = [
                        "name" => $orderItemRow['labor_name'],
                        "price" => number_format($orderItemRow['orderItemPrice'], 2),
                        "qty" => $orderItemRow['orderItemQuantity'],
                        "total" => number_format($orderItemRow['orderItemPrice'] * $orderItemRow['orderItemQuantity'], 2),
                        "tax" => "0.00"
                    ];
                } else {
                    // Add to products
                    $products_info['ITEM'][] = [
                        "name" => $orderItemRow['product_name'],
                        "price" => number_format($orderItemRow['orderItemPrice'], 2),
                        "qty" => $orderItemRow['orderItemQuantity'],
                        "total" => number_format($orderItemRow['orderItemPrice'] * $orderItemRow['orderItemQuantity'], 2),
                        "tax" => "0.00"
                    ];
                }
            }
        }

        class PDF extends FPDF
        {
            // Ensure headers and footers are handled on every page
            function Header()
            {
                // Add fonts
                $this->AddFont("Montserrat-Regular", "", "Montserrat-Regular.php");
                $this->AddFont("Montserrat-Meduim", "", "Montserrat-Medium.php");
                $this->AddFont("Montserrat-Bold", "", "Montserrat-Bold.php");

                // Add logo
                $this->Image('../logo.jpeg', 15, 9, 20); 

                // Set font and display company details
                $this->SetFont("Montserrat-Regular", "", 9);
                $this->SetY(7);
                $this->SetX(40);
                $this->Cell(50, 7, "KSQ 10 ENTERPRISE", 0, 1);
                $this->SetY(13);
                $this->SetX(40);
                $this->Cell(50, 7, "9632 JARAK ATAS,", 0, 1);
                $this->SetY(19);
                $this->SetX(40);
                $this->Cell(50, 7, "TASEK GELUGOR PNG 13310", 0, 1);
                $this->SetY(25);
                $this->SetX(40);
                $this->Cell(50, 7, "Malaysia", 0, 1);

                $this->SetY(7);
                $this->SetX(-40);
                $this->SetFont("Montserrat-Meduim", "", 12);
                $this->Cell(50, 10, "Workshop &", 0, 1);

                $this->SetY(13);
                $this->SetX(-28);
                $this->SetFont("Montserrat-Meduim", "", 12);
                $this->Cell(50, 10, "Repair", 0, 1);

                $this->SetDrawColor(169, 169, 169); 
                $this->Line(10, 37, 202, 37);
                $this->SetY(50);
            }

            function Footer()
            {
                $this->SetY(-55);
                $this->SetFont("Montserrat-Regular", "", 10);
                $this->Cell(0, 10, "Payment terms: 30 Days", 0, 1, "L");
                $this->Cell(0, 5, "Payment Communication: INV/2024/00001", 0, 1, "L");
                $this->Cell(0, 20, "MAYBANK", 0, 1, "L");
                $this->Cell(0, -5, "557410562928", 0, 1, "L");
                $this->Cell(0, 20, "KSQ 10 ENTERPRISE", 0, 1, "L");
                $this->Ln(15);
            }

            function Body($categories, $customerName, $customerAddress1, $customerAddress2, $customerCity, $customerPoscode, $customerState, $plateNumber, $orderDate, $salePerson)
            {
                $grandTotal = 0;
                $this->SetFont("Montserrat-Regular", "", 11);
                
                // Display customer details
                $this->SetY(47);
                $this->SetX(-95);
                $this->Cell(50, 7, "$customerName - $plateNumber");
                $this->SetY(54);
                $this->SetX(-95);
                $this->Cell(50, 7, "$customerAddress1");
                $this->SetY(61);
                $this->SetX(-95);
                $this->Cell(50, 7, "$customerAddress2");
                $this->SetY(68);
                $this->SetX(-95);
                $this->Cell(50, 7, "$customerCity $customerPoscode");
                $this->SetY(75);
                $this->SetX(-95);
                $this->Cell(50, 7, "$customerState");
                $this->SetY(82);
                $this->SetX(-95);
                $this->Cell(50, 7, "Malaysia");

                // Display invoice details
                $this->SetY(90);
                $this->SetX(10);
                $this->SetFont("Montserrat-Regular", "", 20);
                $this->Cell(50, 10, "Invoice " . $_GET['invoice_no'], 0, 1);
                $this->SetY(100);
                $this->SetX(10);
                $this->SetFont("Montserrat-Meduim", "", 10);
                $this->Cell(50, 10, "Invoice Date:", 0, 1);
                $this->SetY(105);
                $this->SetX(10);
                $this->SetFont("Montserrat-Regular", "", 10);
                $this->Cell(50, 10, "$orderDate", 0, 1);
                $this->SetY(100);
                $this->SetX(70);
                $this->SetFont("Montserrat-Meduim", "", 10);
                $this->Cell(50, 10, "Source:", 0, 1);
                $this->SetY(105);
                $this->SetX(70);
                $this->SetFont("Montserrat-Regular", "", 10);
                $this->Cell(50, 10, "$salePerson", 0, 1);

                // Display Table headings
                $this->SetY(120);
                $this->SetX(10);
                $this->SetFont("Montserrat-Meduim", "", 10);
                $this->Cell(90, 9, "Description");
                $this->Cell(20, 9, "Quantity");
                $this->Cell(40, 9, "Unit Taxes Price");
                $this->Cell(18, 9, "Tax excl");
                $this->Cell(20, 9, "Tax incl.", "", 1);

                $this->SetFont("Montserrat-Regular", "", 10);
                $this->SetDrawColor(169, 169, 169); 
                $this->Line(10, 118, 202, 118);

                foreach ($categories as $categoryName => $items) {
                    // Display Category Title
                    $this->SetFillColor(217, 219, 220);
                    $this->SetFont("Montserrat-Meduim", "", 12);
                    $this->SetY($this->GetY() + 2);
                    $this->SetX(10);
                    $this->Cell(0, 10, $categoryName, 0, 1, 'L', true);

                    $this->SetFont("Montserrat-Regular", "", 10);
                    $categorySubtotal = 0;

                    foreach ($items as $index => $item) {
                        // Check if we need to add a new page
                        if ($this->GetY() > 250) {
                            $this->AddPage();
                            $this->Header(); // Add header on new page
                            $this->SetY(120); // Adjust starting Y position on the new page
                        }

                        $this->SetFillColor($index % 2 == 0 ? 254 : 242);
                        $this->Cell(90, 9, $item['name']);
                        $this->Cell(20, 9, $item['qty']);
                        $this->Cell(40, 9, "RM" . $item['price']);
                        $this->Cell(18, 9, $item['tax']);
                        $this->Cell(20, 9, "RM" . $item['total'], "", 1);

                        $total = floatval(str_replace("RM", "", $item["total"]));
                        $categorySubtotal += $total;
                    }

                    $this->SetDrawColor(169, 169, 169);
                    $this->SetFont('Montserrat-Meduim', '', 10);
                    $this->Cell(181, 10, "SUB TOTAL: RM " . number_format($categorySubtotal, 2), 0, 0, 'R');
                    $this->Ln(10);

                    $grandTotal += $categorySubtotal;
                }

                // Display grand total
                $this->SetY(-40); // Move to the bottom of the page
                $this->SetFont("Montserrat-Meduim", "", 10);
                $this->Cell(90, 10, "TOTAL", 0, 0, 'R');
                $this->SetFont('Montserrat-Regular', '', 10);
                $this->Cell(100, 10, "RM " . number_format($grandTotal, 2), 0, 1, 'R');
            }
        }

        // Create instance of PDF class
        $pdf = new PDF();
        $pdf->AddPage();
        $pdf->Body($products_info, $customerName, $customerAddress1, $customerAddress2, $customerCity, $customerPoscode, $customerState, $plateNumber, $orderDate, $salePerson); // Pass the products and customer data to the Body function
        $pdf->Output();

    } else {
        echo "Order not found.";
    }
} else {
    echo "Invalid request.";
}
?>
