<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dropdown Example</title>
    <!-- Bulma CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bulma/0.9.3/css/bulma.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <!-- Optional: Add your custom CSS here -->
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        /* Custom CSS if needed */
    </style>
</head>
<style>
  .button {
    background-color: #007BFF; /* Blue background color */
    color: white; /* White text color */
    border: none; /* No border */
  }

  .button:hover {
    background-color: #0056b3; /* Darker blue on hover */
  }

  .button .icon {
    margin-left: 5px; /* Small margin to the left of the icon */
  }

  .dropdown-menu {
    border: 1px solid #ccc; /* Light grey border for the dropdown */
  }

  .dropdown-item {
    color: #333; /* Dark grey text color */
  }

  .dropdown-item:hover, .dropdown-item.is-active {
    background-color: #007BFF; /* Blue background for active and hovered items */
    color: white; /* White text for active and hovered items */
  }
</style>
<body>
    <div class="dropdown not-active">
        <div class="dropdown-trigger">
            <button class="button" aria-haspopup="true" aria-controls="dropdown-menu">
                <i class="fas fa-print"></i>
                <span class="icon is-small">
                    <i class="fas fa-angle-down" aria-hidden="true"></i>
                </span>
            </button>
        </div>
        <div class="dropdown-menu" id="dropdown-menu" role="menu">
            <div class="dropdown-content">
                <a href="#" class="dropdown-item"> Dropdown item </a>
                <a class="dropdown-item"> Other dropdown item </a>
                <a href="#" class="dropdown-item is-active"> Active dropdown item </a>
            </div>
        </div>
    </div>

    <!-- Optional: Add your custom JavaScript here -->
    <script>
        // JavaScript to toggle dropdown visibility
        document.addEventListener('DOMContentLoaded', () => {
            const dropdown = document.querySelector('.dropdown');
            const button = dropdown.querySelector('.dropdown-trigger button');

            button.addEventListener('click', () => {
                dropdown.classList.toggle('is-active');
            });
        });
    </script>
</body>
</html>
